#include <bits/stdc++.h>
using namespace std;
using ll = long long;
using ld = long double;
const int N = 2e5 + 20;

struct pt{
    ll x, y;
};

pt p0;

pt nextToTop(stack<pt> &S){
    pt p = S.top();
    S.pop();
    pt res = S.top();
    S.push(p);
    return res;
}

void swap(pt &p1, pt &p2){
    pt temp = p1;
    p1 = p2;
    p2 = temp;
}

ll distSq(pt p1, pt p2){
    return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
}

int orientation(pt p, pt q, pt r){
    ll val = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    return (val > 0) ? 1 : (val < 0) ? 2 : 0;
}

int compare(const void *vp1, const void *vp2){
    pt *p1 = (pt *)vp1;
    pt *p2 = (pt *)vp2;

    int o = orientation(p0, *p1, *p2);
    if (o == 0)
        return (distSq(p0, *p2) >= distSq(p0, *p1)) ? -1 : 1;

    return (o == 2) ? -1 : 1;
}

vector<pt> convexHull(vector<pt> &pts, int n){
    int ymin = pts[0].y, min = 0;
    for(int i = 1; i < n; i++){
        ll y = pts[i].y;
        if ((y < ymin) || (ymin == y && pts[i].x < pts[min].x))ymin = pts[i].y, min = i;
    }

    swap(pts[0], pts[min]);
    p0 = pts[0];
    qsort(&pts[1], n - 1, sizeof(pt), compare);

    int m = 1;
    for(int i = 1; i < n; i++){
        while (i < n - 1 && orientation(p0, pts[i], pts[i + 1]) == 0)i++;
        pts[m] = pts[i];
        m++;
    }

    stack<pt> S;
    S.push(pts[0]);
    S.push(pts[1]);
    S.push(pts[2]);

    for(int i = 3; i < m; i++){
        while(S.size() > 1 && orientation(nextToTop(S), S.top(), pts[i]) != 2)S.pop();
        S.push(pts[i]);
    }

    vector<pt> sigma;
    while (!S.empty()){
        pt p = S.top();
        sigma.push_back(p);
        S.pop();
    }

    return sigma;
}

ll polygonArea(const vector<pt> &polygon){
    int n = polygon.size();
    ll area = 0;

    for(int i = 0; i < n; i++){
        int j = (i + 1) % n;
        area += polygon[i].x * polygon[j].y;
        area -= polygon[i].y * polygon[j].x;
    }
    return abs(area) / 2;
}

ll triangleArea(const pt &A, const pt &B, const pt &C){
    return abs(A.x * (B.y - C.y) + B.x * (C.y - A.y) + C.x * (A.y - B.y)) / 2;
}

void solve()
{
    int n;
    cin >> n;

    vector<pt> a(n);
    for(int i = 0; i < n; i++){
        cin >> a[i].x >> a[i].y;
    }

    vector<pt> convex = convexHull(a,n);
    vector<int> indeks;

    int j=0;

    for(int i = n - 1; i >= 0; i--){
        if(convex[j].x == a[i].x && convex[j].y == a[i].y){
            indeks.push_back(i);
            j++;
        }
    }

    /*for (int i = 0; i < indeks.size(); i++)
    {
        cout << indeks[i] << " ";
    }*/

   // cout << "\n";
    ll area = -1;
    ll areax = polygonArea(convex);

    for(int i = 0; i < convex.size(); i++){
        if(i == 0){
            vector<pt> newh;
            for (int j = 1; j < n; j++){
                newh.push_back(a[j]);
            }
            vector<pt> neww = convexHull(newh, n-1);
            ll area1 = polygonArea(neww);
            area = area1;
            continue;
        }

        pt rem = convex[i];

        if(indeks[i] == n - 1 || indeks[i] == 0)continue;

        vector<pt> newpts;
        for(int j = indeks[i - 1]; j >= indeks[i + 1]; j--){
            if (a[j].x == a[indeks[i]].x && a[j].y == a[indeks[i]].y)continue;

            newpts.push_back(a[j]);
        }

        vector<pt> newcon = convexHull(newpts,int(newpts.size()));

        ll areax1 = areax;

        areax1 -= (triangleArea(a[indeks[i - 1]], a[indeks[i]], a[0]) + triangleArea(a[indeks[i]], a[indeks[i + 1]], a[0]));

        for(int j = 0; j < newcon.size()-1; j++){
            areax1 += triangleArea(a[0], newcon[j], newcon[j + 1]);
        }

        area = min(area, areax1);
    }

    cout << area << "\n";
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t = 1;
    //cin >> t;
    while (t--)
    {
        solve();
    }

}